--[[
Part of Production Supply Trader FS25

Copyright (C) braeven 2025

Author: braeven

Important:
No modifications to this script are permitted without Braeven's permission.
You are not allowed to use part of this script without permission.
]]

ProductionSettingsDialog = {}
local ProductionSettingsDialog_mt = Class(ProductionSettingsDialog, YesNoDialog)


function ProductionSettingsDialog.register()
	local productionSettingsDialog = ProductionSettingsDialog.new()
	local path = Utils.getFilename("gui/productionSupplyTrader_settingsDialog.xml", g_currentModDirectory)
	g_gui:loadGui(path, "ProductionSettingsDialog", productionSettingsDialog)
	ProductionSettingsDialog.INSTANCE = productionSettingsDialog
end


function ProductionSettingsDialog.show(callback, target, title, productionPoint)
	if ProductionSettingsDialog.INSTANCE ~= nil then
		local dialog = ProductionSettingsDialog.INSTANCE
		dialog.mode = 0
		dialog.productionPoint = productionPoint
		dialog:setCallback(callback, target)
		dialog:setTitle(title)
		dialog:setText(g_i18n:getText("productionSupplyTrader_DescDistribution"))
		dialog:updateProductionLists()

		g_gui:showDialog("ProductionSettingsDialog")
	end
end


function ProductionSettingsDialog.new(target, custom_mt)
	local self = YesNoDialog.new(target, custom_mt or ProductionSettingsDialog_mt)
	return self
end


--Auswahl verarbeiten
function ProductionSettingsDialog:onClickOk()
	local index = self.productsListMenue:getSelectedIndexInSection()
	local fillType = self.productsList[index]
	if fillType ~= nil then
		local fillTypeIndex = self.productsList[index].fillTypeIndex

		if self.mode == 0 then
			if self.productionPoint.outputFillTypeIds[fillTypeIndex] ~= nil then
				local outputMode = self.productionPoint:getOutputDistributionMode(fillTypeIndex)
				if table.hasElement(ProductionPoint.OUTPUT_MODE, outputMode + 1) then
					self.productionPoint:setOutputDistributionMode(fillTypeIndex, outputMode + 1)
					self:updateProductionLists()
					return
				end
				self.productionPoint:setOutputDistributionMode(fillTypeIndex, 0)
				self:updateProductionLists()
			end
		else
			ProductionBuyGoodsDialog.show(self.productionPoint, self.dialogTitle, fillType, self.mode)
		end
	end
end


--Abbrechen
function ProductionSettingsDialog:onClickBack()
	self:close()
end


--Modus ändern zwischen Lager-Einstellung und Kaufen-Funktion
function ProductionSettingsDialog:onClickChange()
	self.mode = self.mode + 1
	if self.mode > 2 then
		self.mode = 0
	end

	local buttonText = self.yesButton
	if self.mode == 1 then
		self:setText(g_i18n:getText("productionSupplyTrader_DescBuy"))
		buttonText:setText(g_i18n:getText("productionSupplyTrader_ButtonBuy"))
	elseif self.mode == 2 then
		self:setText(g_i18n:getText("productionSupplyTrader_DescSell"))
		buttonText:setText(g_i18n:getText("productionSupplyTrader_ButtonSell"))
	else
		self:setText(g_i18n:getText("productionSupplyTrader_DescDistribution"))
		buttonText:setText(g_i18n:getText("productionSupplyTrader_ButtonDistribution"))
	end
	self:updateProductionLists()
end


--Dialog-Titel einstellen
function ProductionSettingsDialog:setTitle(title)
	ProductionSettingsDialog:superClass().setTitle(self, title)
	self.dialogTitle = title
end


function ProductionSettingsDialog:populateCellForItemInSection(list, section, index, cell)
	if list == self.productsListMenue then
		local entry = self.productsList[index]
		local text = cell:getAttribute("name")
		text:setText(entry.title)
		local icon = cell:getAttribute("icon")
		icon:setImageFilename(entry.icon)

		local outputMode = self.productionPoint:getOutputDistributionMode(entry.fillTypeIndex)
		local outputModeText = g_i18n:getText("ui_production_output_storing")
		if productionSupplyTrader.PSC == true then
			outputModeText = g_i18n:getText("productionSupplyTrader_SpawnOption")
		end

		if self.mode == 1 then
			outputModeText = ""
		elseif self.mode == 2 then
			outputModeText = ""
		elseif outputMode == ProductionPoint.OUTPUT_MODE.DIRECT_SELL then
			outputModeText = g_i18n:getText("ui_production_output_selling")
		elseif outputMode == ProductionPoint.OUTPUT_MODE.AUTO_DELIVER then
			outputModeText = g_i18n:getText("ui_production_output_distributing")
		elseif outputMode == ProductionPoint.OUTPUT_MODE.STORE then
			outputModeText = g_i18n:getText("productionSupplyTrader_StoreOption")
		end
		cell:getAttribute("activity"):setText(outputModeText)

	end
end


function ProductionSettingsDialog:updateProductionLists()
	self.productsList = {}
	local source = self.productionPoint.outputFillTypeIdsArray

	if productionSupplyTrader.PSC == false then
		if self.productionPoint.source == nil then
			self.productionPoint.source = {}
			for i = 1, #self.productionPoint.productions do
				local production = self.productionPoint.productions[i]
				table.addElement(self.productionPoint.source, production.primaryProductFillType)
			end
		end
		source = self.productionPoint.source
	end

	if self.mode == 1 then
		source = self.productionPoint.inputFillTypeIdsArray
	elseif self.mode == 2 then
		source = self.productionPoint.outputFillTypeIdsArray
	end
	
	for _, fillTypeIndex in ipairs(source) do
		local fillLevel = self.productionPoint:getFillLevel(fillTypeIndex)
		local fillType = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex)
		if self.mode == 0 or (self.productionPoint.allowFillTypeIdsBuying[fillTypeIndex] == nil and self.mode == 1) or (self.productionPoint.allowFillTypeIdsSelling[fillTypeIndex] == nil and self.mode == 2) then
			local entry = {}
			entry.title = fillType.title
			entry.icon = fillType.hudOverlayFilename
			entry.fillLevel = fillLevel
			entry.fillTypeIndex = fillTypeIndex
			table.insert(self.productsList, entry)
		end
	end

	self.productsListMenue:setDataSource(self)
	self.productsListMenue:reloadData()
end


function ProductionSettingsDialog:getNumberOfItemsInSection(list, section)
	if list == self.productsListMenue then
		return #self.productsList or 1
	end

	return 1
end