--[[
Part of Production Supply Trader FS25

Copyright (C) braeven 2025

Author: braeven

Important:
No modifications to this script are permitted without Braeven's permission.
You are not allowed to use part of this script without permission.
]]
productionSupplyTrader_EventBuySell = {}
local productionSupplyTrader_EventBuySell_mt = Class(productionSupplyTrader_EventBuySell, Event)
InitEventClass(productionSupplyTrader_EventBuySell, "productionSupplyTrader_EventBuySell")

function productionSupplyTrader_EventBuySell.emptyNew()
	return Event.new(productionSupplyTrader_EventBuySell_mt)
end

function productionSupplyTrader_EventBuySell.new(productionPoint, fillTypeIndex, amount, buySell)
	local self = productionSupplyTrader_EventBuySell.emptyNew()
	self.productionPoint = productionPoint
	self.fillTypeIndex = fillTypeIndex
	self.amount = amount
	self.buySell = buySell

	return self
end

function productionSupplyTrader_EventBuySell:readStream(streamId, connection)
	self.productionPoint = NetworkUtil.readNodeObject(streamId)
	self.fillTypeIndex = streamReadInt32(streamId)
	self.amount = streamReadInt32(streamId)
	self.buySell = streamReadBool(streamId)

	self:run(connection)
end

function productionSupplyTrader_EventBuySell:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.productionPoint)
	streamWriteInt32(streamId, self.fillTypeIndex)
	streamWriteInt32(streamId, self.amount)
	streamWriteBool(streamId, self.buySell)

end

function productionSupplyTrader_EventBuySell:run(connection)
	self.productionPoint:ReceiveBuySellEvent(self.fillTypeIndex, self.amount, self.buySell)
end

function productionSupplyTrader_EventBuySell.sendEvent(productionPoint, fillTypeIndex, amount, buySell)
	g_client:getServerConnection():sendEvent(productionSupplyTrader_EventBuySell.new(productionPoint, fillTypeIndex, amount, buySell))
end