--[[
Part of Production Supply Trader FS25

Copyright (C) braeven 2025

Author: braeven

Important:
No modifications to this script are permitted without Braeven's permission.
You are not allowed to use part of this script without permission.
]]

ProductionBuyGoodsDialog = {}
local ProductionBuyGoodsDialog_mt = Class(ProductionBuyGoodsDialog, YesNoDialog)


function ProductionBuyGoodsDialog.register()
	local productionBuyGoodsDialog = ProductionBuyGoodsDialog.new()
	local path = Utils.getFilename("gui/productionSupplyTrader_buyGoodsDialog.xml", g_currentModDirectory)
	g_gui:loadGui(path, "ProductionBuyGoodsDialog", productionBuyGoodsDialog)
	ProductionBuyGoodsDialog.INSTANCE = productionBuyGoodsDialog
end


function ProductionBuyGoodsDialog.show(productionPoint, title, fillType, buySell)
	if ProductionBuyGoodsDialog.INSTANCE ~= nil then
		local dialog = ProductionBuyGoodsDialog.INSTANCE
		dialog.productionPoint = productionPoint
		--FillType Daten Auslesen
		dialog.fillTypeIndex = fillType.fillTypeIndex
		local fillType = g_fillTypeManager:getFillTypeByIndex(fillType.fillTypeIndex)

		if buySell == 1 then
			dialog.mode = true
			dialog:setText(g_i18n:getText("productionSupplyTrader_DescBuy"))
			dialog.pricePerLiter = fillType.pricePerLiter * 2 * EconomyManager.getPriceMultiplier()
			dialog.max = productionPoint.storage:getFreeCapacity(dialog.fillTypeIndex)
		else
			dialog.mode = false
			dialog:setText(g_i18n:getText("productionSupplyTrader_DescSell"))
			dialog.pricePerLiter = fillType.pricePerLiter * EconomyManager.getPriceMultiplier() * ProductionPoint.DIRECT_SELL_PRICE_FACTOR
			dialog.max = productionPoint.storage:getFillLevel(dialog.fillTypeIndex)
		end
		dialog:setTitle(title)
		
		dialog.fillTypeIcon:setImageFilename(fillType.hudOverlayFilename)
		dialog.unitShort = fillType.unitShort
		if dialog.unitShort == "" then
			dialog.unitShort = g_i18n:getText("unit_literShort")
		end

		dialog.fillTypeText:setText(fillType.title)
		dialog.fillTypePrice:setText(g_i18n:formatMoney(math.round(dialog.pricePerLiter * 1000), 0) .. " / " ..g_i18n:formatVolume(1000, 0 , dialog.unitShort))

		dialog:setLimit()

		g_gui:showDialog("ProductionBuyGoodsDialog")
	end
end


function ProductionBuyGoodsDialog.new(target, custom_mt)
	local self = YesNoDialog.new(target, custom_mt or ProductionBuyGoodsDialog_mt)
	self.selectedAmount = 0
	return self
end


function ProductionBuyGoodsDialog.createFromExistingGui(gui, guiName)
	ProductionBuyGoodsDialog.register()
	local callback = gui.callbackFunc
	local target = gui.target
	local title = gui.dialogTitle
	local fillTypesSelection = gui.fillTypesSelection
	ProductionBuyGoodsDialog.show(callback, target, title, fillTypesSelection)
end


--Auswahl verarbeiten
function ProductionBuyGoodsDialog:onClickOk()
	local amount = self.amountElement:getState() - 1
	productionSupplyTrader_EventBuySell.sendEvent(self.productionPoint, self.fillTypeIndex, amount, self.mode)
	self:close()
end


--Abbrechen
function ProductionBuyGoodsDialog:onClickBack()
	self:close()
end



--Angezeigte Menge ändern
function ProductionBuyGoodsDialog:setLimit()
	local amountTexts = {}

	for i = 0, self.max do
		local price = math.round(self.pricePerLiter * i)
		local text = g_i18n:formatVolume(i, 0 , self.unitShort) .. " - ".. g_i18n:formatMoney(price, 0)
		table.insert(amountTexts, text)
	end

	self.amountElement:setTexts(amountTexts)
	self.selectedAmount = 0
	self.amountElement:setState(self.selectedAmount, true)
end


--Slider Position ändern
function ProductionBuyGoodsDialog:onClickAmount(state)
	self.selectedAmount = state
end


--Dialog-Titel einstellen
function ProductionBuyGoodsDialog:setTitle(title)
	ProductionBuyGoodsDialog:superClass().setTitle(self, title)
	self.dialogTitle = title
end



-- -100 Butten
function ProductionBuyGoodsDialog:onClickLeft100(element)
	self:updateAmount(-100)
end



-- -1000 Butten
function ProductionBuyGoodsDialog:onClickLeft1000()
	self:updateAmount(-1000)
end


-- +100 Butten
function ProductionBuyGoodsDialog:onClickRight100()
	self:updateAmount(100)
end


-- +1000 Butten
function ProductionBuyGoodsDialog:onClickRight1000()
	self:updateAmount(1000)
end


-- max Butten
function ProductionBuyGoodsDialog:onClickMax()
--todo
	self:updateAmount(self.max + 1, true)
end

-- max Butten
function ProductionBuyGoodsDialog:onClickNull()
--todo
	self:updateAmount(1, true)
end

--Buttens anlegen
function ProductionBuyGoodsDialog:onCreateButten()

end


--Butten Eingabe verarbeiten
function ProductionBuyGoodsDialog:updateAmount(amount, force)
	local oldAmount = self.amountElement:getState()
	local newAmount = oldAmount + amount
	if force == true then
		newAmount = amount
	else
		if oldAmount == 0 then
			newAmount = newAmount + 1
		end
		if newAmount > self.max + 1 then 
			newAmount = self.max + 1
		end
	end

	self.selectedAmount = newAmount
	self.amountElement:setState(self.selectedAmount, true)
end
