--[[
Part of Production Supply Trader FS25

Copyright (C) braeven 2025

Author: braeven

Important:
No modifications to this script are permitted without Braeven's permission.
You are not allowed to use part of this script without permission.
]]

local mod = g_modManager:getModByName("FS25_0_ProductionRevamp")
local loadPSC = true

if mod ~= nil then
	if g_modIsLoaded[mod.modName] then
		loadPSC = false
		print("Loading Production Supply Trader was stopped, Production Revamp was detected")
	end
end

if loadPSC == true then
	source(g_currentModDirectory .. "scripts/productionSupplyTrader_ingameMenue.lua")
	source(g_currentModDirectory .. "scripts/productionSupplyTrader_settingsDialog.lua")
	source(g_currentModDirectory .. "scripts/productionSupplyTrader_buyGoodsDialog.lua")
	source(g_currentModDirectory .. "scripts/productionSupplyTrader_event_buySell.lua")
	source(g_currentModDirectory .. "scripts/productionSupplyTrader_buySell.lua")
	source(g_currentModDirectory .. "scripts/productionSupplyTrader_main.lua")

	ProductionSettingsDialog.register()
	ProductionBuyGoodsDialog.register()
end